// Variables qui nous permettront de savoir quand le jeu démarre ou quand il y a un GAME OVER
var GAME_START = false;
var GAME_OVER = false;

// Taille du jeu (mode portrait)
const width = 1080;
const height = 1775;

// Phaser
var game = new Phaser.Game(width, height, Phaser.AUTO, 'timberman');
game.transparent = true;

// On déclare un objet qui contiendra les états "load" et "main"
var gameState = {};
gameState.load = function() { };
gameState.main = function() { };

// Va contenir le code qui chargera les ressources
gameState.load.prototype = {
	preload: function() {
		// Chargement de l'image du background
		game.load.image('background', 'img/background.png');
		// Chargement du personnage - PNG et JSON
		game.load.atlas('man', 'img/man.png', 'data/man.json');
		// Arbre
		game.load.image('trunk1', 'img/trunk1.png');
		game.load.image('trunk2', 'img/trunk2.png');
		game.load.image('branch1', 'img/branch1.png');
		game.load.image('branch2', 'img/branch2.png');
		game.load.image('stump', 'img/stump.png');
	},

	create: function() {
		game.state.start('main');
	}
};

// va contenir le coeur du jeu
gameState.main.prototype = {
	create: function() {
		// Physique du jeu
		game.physics.startSystem(Phaser.Physics.ARCADE);

		// On fait en sorte que le jeu se redimensionne selon la taille de l'écran (Pour les PC)
		game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
		game.scale.setShowAll();
		window.addEventListener('resize', function () {
			game.scale.refresh();
		});
		game.scale.refresh();

		// Création de l'arrière-plan dans le Canvas
		this.background = game.add.sprite(0, 0, 'background');
		this.background.width = game.width;
		this.background.height = game.height;

		// ---- ARBRE
		// souche
		this.stump = game.add.sprite(0, 0, 'stump');
		this.stump.x = 352;
		this.stump.y = 1394;
		// construction de l'arbre
		this.HEIGHT_TRUNK = 243;
		this.constructTree();
		this.canCut = true;

		// ---- BÛCHERON
		// Création du bûcheron
		this.man = game.add.sprite(0, 1070, 'man');
		// On ajoute l'animation de la respiration (fait appel au JSON)
		this.man.animations.add('breath', [0,1]);
		// On ajoute l'animation de la coupe (fait appel au JSON)
		this.man.animations.add('cut', [1,2,3,4]);
		// On fait démarrer l'animation, avec 3 images par seconde et répétée en boucle
		this.man.animations.play('breath', 3, true);
		// Position du bûcheron
		this.manPosition = 'left';

		// Au click, on appelle la fonction "listener()"
		game.input.onDown.add(this.listener, this);
	},

	update: function() {
		// Si la partie n'est pas terminée
		if(!GAME_OVER) {
			// Détection des touches left et right du clavier
			if (game.input.keyboard.justPressed(Phaser.Keyboard.LEFT))
		        this.listener('left');
		    else if (game.input.keyboard.justPressed(Phaser.Keyboard.RIGHT)) {
		        this.listener('right');
		    }
		}
	},

	listener: function(action) {

		if(this.canCut) {

			// La première action de l'utilisateur déclenche le début de partie
			if(!GAME_START)
				GAME_START = true;

			// On vérifie si l'action du joueur est un clic
			var isClick = action instanceof Phaser.Pointer;

			// Si la touche directionnelle gauche est pressée ou s'il y a un clic dans la moitié gauche du jeu
			if(action == 'left' || (isClick && game.input.activePointer.x <= game.width / 2)) {
				// On remet le personnage à gauche de l'arbre et dans le sens de départ
				this.man.anchor.setTo(0, 0);
				this.man.scale.x = 1;
				this.man.x = 0;
				this.manPosition = 'left';
			// Si la touche directionnelle droite est pressée ou s'il y a un clic dans la moitié droite du jeu
			} else {
				// On inverse le sens du personnage pour le mettre à droite de l'arbre
				this.man.anchor.setTo(1, 0);
				this.man.scale.x = -1;
				this.man.x = game.width - Math.abs(this.man.width);
				this.manPosition = 'right';
			}

			// On stop l'animation de respiration
			this.man.animations.stop('breath', true);
			// Pour démarrer l'animation de la coupe, une seule fois et avec 3 images par seconde
			var animationCut = this.man.animations.play('cut', 15);
			// Une fois que l'animation de la coupe est finie, on reprend l'animation de la respiration
			animationCut.onComplete.add(function() {
				this.man.animations.play('breath', 3, true);
			}, this);

			this.cutTrunk();
		}
	},

	cutTrunk: function() {
		// On ajoute un tronc ou une branche		
		this.addTrunk();

		// On crée une copie du morceau de l'arbre qui doit être coupé
		var trunkCut = game.add.sprite(37, 1151, this.tree.getAt(0).key);
		// Et on supprime le morceau appartenant à l'arbre 
		this.tree.remove(this.tree.getAt(0));
		// On active le système de physique sur ce sprite
		game.physics.enable(trunkCut, Phaser.Physics.ARCADE);
		// On déplace le centre de gravité du sprite en son milieu, ce qui nous permettra de lui faire faire une rotation sur lui même
		trunkCut.anchor.setTo(0.5, 0.5);
		trunkCut.x += trunkCut.width / 2;
		trunkCut.y += trunkCut.height / 2;

		var angle = 0;
		// Si le personnage se trouve à gauche, on envoie le morceau de bois vers la droite
		if(this.manPosition == 'left') {
			trunkCut.body.velocity.x = 1300;
			angle = -400;
		// Sinon, on l'envoie vers la gauche
		} else {
			trunkCut.body.velocity.x = -1300;
			angle = 400;
		}
		// Permet de créer un effet de gravité
		// Dans un premier temps, le morceau de bois est propulsé en l'air
		trunkCut.body.velocity.y = -800;
		// Et dans un second temps, il retombe
		trunkCut.body.gravity.y = 2000;

		// On ajoute une animation de rotation sur le morceau de bois coupé
		game.add.tween(trunkCut).to({angle: trunkCut.angle + angle}, 1000, Phaser.Easing.Linear.None,true);

		// On empêche une nouvelle coupe
		this.canCut = false;

		var self = this;
		// Pour chaque morceau (troncs et branches) de l'arbre, on lui ajoute une animation de chute.
		// Donne l'impression que tout l'arbre tombe pour boucher le trou laissé par le morceau coupé.
		this.tree.forEach(function(trunk) {
			var tween = game.add.tween(trunk).to({y: trunk.y + self.HEIGHT_TRUNK}, 100, Phaser.Easing.Linear.None,true);
			tween.onComplete.add(function() {
				// Une fois que l'arbre à fini son animation, on redonne la possibilité de couper
				self.canCut = true;
			}, self);
		});
	},

	constructTree: function() {
		// On construit le groupe this.tree qui va contenir toutes les parties de l'arbre (troncs simple et branches)
		this.tree = game.add.group();
		// Les 2 premiers troncs sont des troncs simples
		this.tree.create(37, 1151, 'trunk1');
		this.tree.create(37, 1151 - this.HEIGHT_TRUNK, 'trunk2');

		// On construit le reste de l'arbre
		for(var i = 0; i < 4; i++) {
			this.addTrunk();
		}
	},

	addTrunk: function() {
		var trunks = ['trunk1', 'trunk2'];
		var branchs = ['branch1', 'branch2'];
		// Si le dernier tronc du groupe this.tree n'est pas une branche
		if(branchs.indexOf(this.tree.getAt(this.tree.length - 1).key) == -1) {
			// 1 chance sur 4 de placer un tronc sans branche
			if(Math.random() * 4 <= 1)
				this.tree.create(37, this.stump.y - this.HEIGHT_TRUNK * (this.tree.length + 1), trunks[Math.floor(Math.random() * 2)]);
			// 3 chances sur 4 de placer une branche
			else	
				this.tree.create(37, this.stump.y - this.HEIGHT_TRUNK * (this.tree.length + 1), branchs[Math.floor(Math.random() * 2)]);
		}
		// Si le tronc précédent est une branche, on place un tronc simple
		else
			this.tree.create(37, this.stump.y - this.HEIGHT_TRUNK * (this.tree.length + 1), trunks[Math.floor(Math.random() * 2)]);
	}
};


// On ajoute les 2 fonctions "gameState.load" et "gameState.main" à notre objet Phaser
game.state.add('load', gameState.load);
game.state.add('main', gameState.main);
// Il ne reste plus qu'à lancer l'état "load"
game.state.start('load');